VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "KMBCTM to generate delayed Pulse"
   ClientHeight    =   4305
   ClientLeft      =   2280
   ClientTop       =   1770
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   4305
   ScaleWidth      =   5250
   Begin VB.TextBox Text6 
      Enabled         =   0   'False
      Height          =   375
      Left            =   3480
      TabIndex        =   8
      Top             =   2640
      Width           =   735
   End
   Begin VB.TextBox Text5 
      Enabled         =   0   'False
      Height          =   375
      Left            =   3480
      TabIndex        =   7
      Top             =   2040
      Width           =   735
   End
   Begin VB.TextBox Text4 
      Height          =   375
      Left            =   3480
      TabIndex        =   6
      Text            =   "1000"
      Top             =   1440
      Width           =   735
   End
   Begin VB.TextBox Text3 
      Enabled         =   0   'False
      Height          =   375
      Left            =   1680
      TabIndex        =   4
      Top             =   2640
      Width           =   735
   End
   Begin VB.TextBox Text2 
      Enabled         =   0   'False
      Height          =   375
      Left            =   1680
      TabIndex        =   3
      Top             =   2040
      Width           =   735
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   1680
      TabIndex        =   2
      Text            =   "1000"
      Top             =   1440
      Width           =   735
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   4440
      Top             =   2160
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdInt3 
      Caption         =   "Use Internal3"
      Enabled         =   0   'False
      Height          =   615
      Left            =   3120
      TabIndex        =   1
      Top             =   720
      Width           =   1455
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Use Internal1"
      Enabled         =   0   'False
      Height          =   615
      Left            =   1200
      TabIndex        =   0
      Top             =   720
      Width           =   1455
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   240
      TabIndex        =   12
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label Label4 
      BackColor       =   &H8000000E&
      Caption         =   "Total duration is 3 seconds.  Pulse is 3 - requested delay."
      Height          =   375
      Left            =   600
      TabIndex        =   11
      Top             =   3240
      Width           =   4455
   End
   Begin VB.Label Label3 
      Caption         =   "Equivalent Tics"
      Height          =   375
      Left            =   360
      TabIndex        =   10
      Top             =   2640
      Width           =   1215
   End
   Begin VB.Label Label2 
      Caption         =   "duration (sec)"
      Height          =   255
      Left            =   480
      TabIndex        =   9
      Top             =   2040
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "delay (msec)"
      Height          =   255
      Left            =   480
      TabIndex        =   5
      Top             =   1440
      Width           =   975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' tested with CTM-850A01.0.0.2 revision level with Win98SE
' use a storage scope or other reliable means to witness the pulse
' generated by counter 0 of the CTM Series board
'
' in the DriverLINX Config Panel, required settings:
'  C/T Tab, Resolution = 1MHz
'  Freq Scaler = BCD (..Special Button)
'
' NOTE:  when Freq Scaler is on Binary, crazy results occur for the pulse delay/duration
''
' This example assumes a total time of 3 seconds is used (delay + pulse duration = 3)
' The program takes the delay from the VB form, subtracts it from 3 seconds to compute
' the duration of the pulse.


Private Sub cmdInt3_Click()
' this method appears to be reliable for all requested values of delay
' that are less than 3 seconds
Dim result As Integer
Dim delay As Single
Dim duration As Single
' bring in the requested value of delay
delay = Val(Text4.Text) / 1000#  ' convert to seconds
' assumed total duration is 3000 msec.....duration of onCount is total - delay
duration = (3000 - Val(Text4.Text)) / 1000  'convert to seconds
Text5.Text = duration
'  ****************************
'
' when using BCD Freq Scaler, INTERNAL3 timebase is 10KHz
' DLSecs2Tics method of SR control always assumes use of DL_INTERNAL1, eg,
' 1 second results in 1,000,000 tics
Dim Int3Base As Integer
Int3Base = 10000
delay = delay * Int3Base  ' desired seconds * pulse/sec of the time base
duration = duration * Int3Base
Text6.Text = duration
Beep
'stop any active task
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With


With DriverLINXSR1
'set it back to a start operation
.Req_op = DL_START
End With

'StartPulseStrobe(dl As DriverLINXSR, ByVal LogicalDevice As Integer,_
'ByVal LogicalChannel As Integer, ByVal delay As Long, ByVal duration As_
'Long, ByVal retrig As Integer, ByVal pulses As Integer, ByVal source As Integer,_
'ByVal gate As Integer, ByVal clkOut As Integer)
'                                  device,chan,delay,duration,retrig,pulses,timebase,gate,output
result = StartPulseStrobe(DriverLINXSR1, 0, 0, delay, duration, 0, 1, DL_INTERNAL3, DL_NOCONNECT, CT_Output_LoToggled)

' display message box if an error occured
With DriverLINXSR1
.Req_op = DL_MESSAGEBOX
.Refresh
End With
End Sub

Private Sub cmdStart_Click()
' uses INTERNAL1 timebase (1MHz in DLinx Config Panel)
' when requested delay/duration exceed 65535, DriverLINX
' automatically determines which combination of slower timebase/fewer counts
' are required to carry out the task.
' Seems to work usually, but for delays smaller than 650 msec it does not.
' Best then to use the explicitly use Internal3 timebase as illustrated in cmdInt3_Click()
Dim result As Integer
Dim delay As Single
Dim duration As Single
' bring in the requested value of delay
delay = Val(Text1.Text) / 1000#  ' convert to seconds
' total duration is 3000 msec.....duration of onCount is total - delay
duration = (3000 - Val(Text1.Text)) / 1000  'convert to seconds
Text2.Text = duration
' DLSecs2Tics always assumes use of DL_INTERNAL1, eg,
' 1 second results in 1,000,000 tics
delay = DriverLINXSR1.DLSecs2Tics(0, delay)
duration = DriverLINXSR1.DLSecs2Tics(0, duration)
Text3.Text = duration
Beep
'stop any active task
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With


With DriverLINXSR1
'set it back to a start operation
.Req_op = DL_START
End With

'StartPulseStrobe(dl As DriverLINXSR, ByVal LogicalDevice As Integer,_
'ByVal LogicalChannel As Integer, ByVal delay As Long, ByVal duration As_
'Long, ByVal retrig As Integer, ByVal pulses As Integer, ByVal source As Integer,_
'ByVal gate As Integer, ByVal clkOut As Integer)
'                                  device,chan,delay,duration,retrig,pulses,timebase,gate,output
result = StartPulseStrobe(DriverLINXSR1, 0, 0, delay, duration, 0, 1, DL_INTERNAL1, DL_NOCONNECT, CT_Output_LoToggled)

' display message box if an error occured
With DriverLINXSR1
.Req_op = DL_MESSAGEBOX
.Refresh
End With

End Sub

'**************************************************
' Use this procedure to generate pulses and strobes
'**************************************************

Function StartPulseStrobe(dl As DriverLINXSR, ByVal LogicalDevice As Integer, ByVal LogicalChannel As Integer, ByVal delay As Long, ByVal duration As Long, ByVal retrig As Integer, ByVal pulses As Integer, ByVal source As Integer, ByVal gate As Integer, ByVal clkOut As Integer) As Integer
  ' Setup Service Request to perform task
  With dl
    .Req_device = LogicalDevice
    .Req_subsystem = DL_CT
    .Req_mode = DL_POLLED
    .Req_op = DL_START
    .Evt_Tim_type = DL_RATEEVENT
    .Evt_Tim_rateChannel = LogicalChannel
    .Evt_Tim_rateMode = 13 ' DL_PULSEGEN
    .Evt_Tim_rateClock = source
    .Evt_Tim_rateGate = gate
    .Evt_Tim_ratePeriod = delay
    .Evt_Tim_rateOnCount = duration
    'Debug.Print "Delay is : " & Str(delay) & " Duration is : " & Str(duration)
    .Evt_Tim_ratePulses = pulses
    .Evt_Tim_rateOutput = clkOut
    ' Other events, buffers, channels unneeded
    .Evt_Str_type = DL_NULLEVENT
    .Evt_Stp_type = DL_TCEVENT
    .Sel_buf_N = 0
    .Sel_chan_N = 0
    .Refresh
    StartPulseStrobe = .Res_result
  End With
End Function

Private Sub Form_Load()
With DriverLINXSR1
.Req_DLL_name = "KMBCTM"  ' open the driver
' initialize the board
.Req_device = 0
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
' enable buttons
cmdInt3.Enabled = True
cmdStart.Enabled = True
Else
MsgBox "Could not Initialize CTM, Device 0.  Make sure your CTM board is Device 0", vbOKOnly
End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
' stop any active task just for safe measure
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
' unload the driver
DriverLINXSR1.Req_DLL_name = ""
End Sub
